/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.java.parser.JavaParser;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPJavaParserCheck
extends BaseFileCheck {
    private static final Log _log = LogFactoryUtil.getLog(JSPJavaParserCheck.class);
    private static final Pattern _javaSourcePattern = Pattern.compile("\n(\t*)(.*)<%=?\n(((?!%>)[\\s\\S])*)\n\t*%>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _javaSourcePattern.matcher(content);
        while (matcher.find()) {
            try {
                String replacement;
                String match;
                String indent = matcher.group(1);
                if (Validator.isNotNull(matcher.group(2))) {
                    indent = indent + "\t";
                }
                if ((match = matcher.group(3)).equals(replacement = JavaParser.parseSnippet(match, indent))) continue;
                return StringUtil.replaceFirst(content, match, replacement, matcher.start());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug(exception);
            }
        }
        return content;
    }
}

