/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.util;

/**
 * @author Hugo Huijser
 */
public class LegacyProperty {

	public LegacyProperty(
		String legacyPropertyName, String moduleName, String newPropertyName,
		String variableName) {

		_legacyPropertyName = legacyPropertyName;
		_moduleName = moduleName;
		_newPropertyName = newPropertyName;
		_variableName = variableName;

		if (variableName.startsWith("_MIGRATED")) {
			_legacyPropertyAction = LegacyPropertyAction.MIGRATED;
		}
		else if (variableName.startsWith("_MODULARIZED")) {
			_legacyPropertyAction = LegacyPropertyAction.MODULARIZED;
		}
		else if (variableName.startsWith("_OBSOLETE")) {
			_legacyPropertyAction = LegacyPropertyAction.OBSOLETE;
		}
		else {
			_legacyPropertyAction = LegacyPropertyAction.RENAMED;
		}

		if (variableName.contains("_PORTAL_")) {
			_legacyPropertyType = LegacyPropertyType.PORTAL;
		}
		else {
			_legacyPropertyType = LegacyPropertyType.SYSTEM;
		}
	}

	public LegacyPropertyAction getLegacyPropertyAction() {
		return _legacyPropertyAction;
	}

	public String getLegacyPropertyName() {
		return _legacyPropertyName;
	}

	public LegacyPropertyType getLegacyPropertyType() {
		return _legacyPropertyType;
	}

	public String getModuleName() {
		return _moduleName;
	}

	public String getNewPropertyName() {
		return _newPropertyName;
	}

	public String getVariableName() {
		return _variableName;
	}

	private final LegacyPropertyAction _legacyPropertyAction;
	private final String _legacyPropertyName;
	private final LegacyPropertyType _legacyPropertyType;
	private final String _moduleName;
	private final String _newPropertyName;
	private final String _variableName;

}