/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.processor;

import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.util.SourceFormatterUtil;

import java.io.File;
import java.io.IOException;

import java.util.Collections;
import java.util.List;

/**
 * @author Hugo Huijswer
 */
public class UpgradeSourceProcessor extends BaseSourceProcessor {

	@Override
	protected List<String> doGetFileNames() throws IOException {
		SourceFormatterArgs sourceFormatterArgs = getSourceFormatterArgs();

		File upgradeInputDataDirectory = SourceFormatterUtil.getFile(
			sourceFormatterArgs.getBaseDirName(),
			SourceFormatterUtil.UPGRADE_INPUT_DATA_DIRECTORY_NAME,
			sourceFormatterArgs.getMaxDirLevel());

		if (upgradeInputDataDirectory == null) {
			return Collections.emptyList();
		}

		return getFileNames(new String[0], getIncludes());
	}

	@Override
	protected String[] doGetIncludes() {
		return _INCLUDES;
	}

	private static final String[] _INCLUDES = {"**/*.java"};

}