/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.processor;

import com.liferay.source.formatter.util.CETUtil;
import com.liferay.source.formatter.util.FileUtil;

import java.io.File;
import java.io.IOException;

import java.util.List;

/**
 * @author Peter Shin
 */
public class CETSourceProcessor extends BaseSourceProcessor {

	@Override
	protected List<String> doGetFileNames() throws IOException {
		return getFileNames(new String[0], getIncludes());
	}

	@Override
	protected String[] doGetIncludes() {
		return _INCLUDES;
	}

	@Override
	protected void postFormat() throws Exception {
		if (!isPortalSource()) {
			return;
		}

		List<String> fileNames = doGetFileNames();

		if (fileNames.isEmpty()) {
			return;
		}

		String shortFileName = "client-extension-types.json";

		File jsonFile = new File(
			getPortalDir(),
			"modules/apps/client-extension/client-extension-type-api/src/main" +
				"/resources/com/liferay/client/extension/type/dependencies/" +
					shortFileName);

		String newContent = CETUtil.getJSONContent(fileNames);
		String oldContent = FileUtil.read(jsonFile);

		if (!oldContent.equals(newContent)) {
			FileUtil.write(jsonFile, newContent);

			System.out.println("Updated '" + shortFileName + "'");
		}
	}

	private static final String[] _INCLUDES = {
		"**/client-extension-type-api/src/main/java/com/liferay/client" +
			"/extension/type/*.java"
	};

}