/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.parser;

/**
 * @author Hugo Huijser
 */
public class JavaMethod extends BaseJavaTerm {

	public JavaMethod(
		String name, String content, String accessModifier, int lineNumber,
		boolean isAbstract, boolean isFinal, boolean isStatic) {

		super(
			name, content, accessModifier, lineNumber, isAbstract, isFinal,
			isStatic);
	}

	@Override
	public JavaSignature getSignature() {
		if (_signature == null) {
			_signature = JavaSignatureParser.parseJavaSignature(
				getContent(), getAccessModifier(), getPackageName(),
				getImportNames(), true);
		}

		return _signature;
	}

	private JavaSignature _signature;

}