/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.GetterUtil;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class SizeIsZeroCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.CTOR_DEF, TokenTypes.METHOD_DEF};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		List<DetailAST> methodCallDetailASTList = getMethodCalls(
			detailAST, "size");

		for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
			_checkMethodCall(detailAST, methodCallDetailAST);
		}
	}

	private void _checkMethodCall(
		DetailAST detailAST, DetailAST methodCallDetailAST) {

		DetailAST nextSiblingDetailAST = methodCallDetailAST.getNextSibling();

		if ((nextSiblingDetailAST == null) ||
			(nextSiblingDetailAST.getType() != TokenTypes.NUM_INT)) {

			return;
		}

		int compareCount = GetterUtil.getInteger(
			nextSiblingDetailAST.getText());

		DetailAST parentDetailAST = methodCallDetailAST.getParent();

		if (((compareCount != 0) ||
			 ((parentDetailAST.getType() != TokenTypes.EQUAL) &&
			  (parentDetailAST.getType() != TokenTypes.NOT_EQUAL) &&
			  (parentDetailAST.getType() != TokenTypes.GT))) &&
			((compareCount != 1) ||
			 ((parentDetailAST.getType() != TokenTypes.GE) &&
			  (parentDetailAST.getType() != TokenTypes.LT)))) {

			return;
		}

		String variableName = getName(methodCallDetailAST.getFirstChild());

		String variableTypeName = getVariableTypeName(
			detailAST, variableName, false);

		if (variableTypeName.matches("Collection|List|Map|Set")) {
			log(
				methodCallDetailAST, _MSG_USE_METHOD,
				variableName + ".isEmpty()");
		}
	}

	private static final String _MSG_USE_METHOD = "method.use";

}