/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;

import java.util.List;

/**
 * @author Alan Huang
 */
public class OSGiResourceBuilderCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.CLASS_DEF};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		DetailAST annotationDetailAST = AnnotationUtil.getAnnotation(
			detailAST, "Component");

		if (annotationDetailAST == null) {
			return;
		}

		List<String> importNames = null;

		List<DetailAST> methodCallDetailASTList = getAllChildTokens(
			detailAST, true, TokenTypes.METHOD_CALL);

		for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
			String methodName = getMethodName(methodCallDetailAST);

			if (!methodName.equals("builder")) {
				continue;
			}

			String classOrVariableName = getClassOrVariableName(
				methodCallDetailAST);

			if ((classOrVariableName == null) ||
				!classOrVariableName.matches("[A-Z].*Resource")) {

				return;
			}

			if (importNames == null) {
				importNames = getImportNames(methodCallDetailAST);
			}

			String fullyQualifiedClassName = classOrVariableName;

			for (String importName : importNames) {
				if (importName.endsWith("." + classOrVariableName)) {
					fullyQualifiedClassName = importName;

					break;
				}
			}

			if (!fullyQualifiedClassName.contains(".client.")) {
				log(methodCallDetailAST, _MSG_AVOID_METHOD_CALL);
			}
		}
	}

	private static final String _MSG_AVOID_METHOD_CALL = "method.call.avoid";

}