/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

import java.util.List;

/**
 * @author Alan Huang
 */
public class NullAssertionInIfStatementCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.LITERAL_IF};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		DetailAST firstChildDetailAST = detailAST.getFirstChild();

		DetailAST exprDetailAST = firstChildDetailAST.getNextSibling();

		List<DetailAST> compareDetailASTList = getAllChildTokens(
			exprDetailAST, true, TokenTypes.EQUAL, TokenTypes.NOT_EQUAL);

		for (DetailAST compareDetailAST : compareDetailASTList) {
			DetailAST identDetailAST = compareDetailAST.getFirstChild();

			if ((identDetailAST == null) ||
				(identDetailAST.getType() != TokenTypes.IDENT)) {

				continue;
			}

			DetailAST nextSiblingDetailAST = identDetailAST.getNextSibling();

			if (nextSiblingDetailAST.getType() != TokenTypes.LITERAL_NULL) {
				continue;
			}

			DetailAST parentDetailAST = compareDetailAST.getParent();

			List<DetailAST> methodCallDetailASTList = getAllChildTokens(
				parentDetailAST, true, TokenTypes.METHOD_CALL);

			if (methodCallDetailASTList.isEmpty()) {
				continue;
			}

			int compareColumnNumber = compareDetailAST.getColumnNo();
			int compareStartLineNumber = getStartLineNumber(compareDetailAST);

			String variableName = identDetailAST.getText();

			for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
				if (!variableName.equals(
						getVariableName(methodCallDetailAST))) {

					continue;
				}

				int methodCallColumnNumber = methodCallDetailAST.getColumnNo();
				int methodCallStartLineNumber = getStartLineNumber(
					methodCallDetailAST);

				if ((compareStartLineNumber == methodCallStartLineNumber) &&
					(compareColumnNumber > methodCallColumnNumber)) {

					log(
						nextSiblingDetailAST, _MSG_MOVE_NULL_CHECK,
						variableName);
				}

				if (compareStartLineNumber > methodCallStartLineNumber) {
					log(
						nextSiblingDetailAST, _MSG_MOVE_NULL_CHECK,
						variableName);
				}
			}
		}
	}

	private static final String _MSG_MOVE_NULL_CHECK = "null.check.move";

}