/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class NotRequireThisCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.CTOR_DEF, TokenTypes.METHOD_DEF};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		List<DetailAST> thisDetailASTList = getAllChildTokens(
			detailAST, true, TokenTypes.LITERAL_THIS);

		outerLoop:
		for (DetailAST thisDetailAST : thisDetailASTList) {
			if (thisDetailAST.getPreviousSibling() != null) {
				continue;
			}

			DetailAST parentDetailAST = thisDetailAST.getParent();

			if (parentDetailAST.getType() != TokenTypes.DOT) {
				continue;
			}

			String name = getName(parentDetailAST);

			List<DetailAST> definitionDetailASTList = getAllChildTokens(
				detailAST, true, TokenTypes.PARAMETER_DEF, TokenTypes.RESOURCE,
				TokenTypes.VARIABLE_DEF);

			for (DetailAST definitionDetailAST : definitionDetailASTList) {
				if (name.equals(getName(definitionDetailAST))) {
					continue outerLoop;
				}
			}

			log(thisDetailAST, _MSG_VARIABLE_THIS_NOT_REQUIRED, name);
		}
	}

	private static final String _MSG_VARIABLE_THIS_NOT_REQUIRED =
		"variable.not.require.this";

}