/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

import java.util.List;

/**
 * @author Alan Huang
 */
public class ExceptionPrintStackTraceCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.LITERAL_CATCH};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		String absolutePath = getAbsolutePath();

		if (absolutePath.contains("/modules/sdk/") ||
			absolutePath.contains("/modules/util/") ||
			absolutePath.contains("/test/") ||
			absolutePath.contains("/testIntegration/") ||
			absolutePath.endsWith("Jdk14LogFactoryImpl.java")) {

			return;
		}

		DetailAST parameterDefinitionDetailAST = detailAST.findFirstToken(
			TokenTypes.PARAMETER_DEF);

		String exceptionVariableName = getName(parameterDefinitionDetailAST);

		String variableTypeName = getVariableTypeName(
			detailAST, exceptionVariableName, false);

		if ((variableTypeName == null) ||
			!variableTypeName.endsWith("Exception")) {

			return;
		}

		List<DetailAST> methodCallDetailASTList = getMethodCalls(
			detailAST, exceptionVariableName, "printStackTrace");

		if (methodCallDetailASTList.isEmpty()) {
			return;
		}

		for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
			DetailAST parameterDetailAST = getParameterDetailAST(
				methodCallDetailAST);

			if (parameterDetailAST != null) {
				continue;
			}

			log(methodCallDetailAST, _MSG_AVOID_METHOD_CALL);
		}
	}

	private static final String _MSG_AVOID_METHOD_CALL = "method.call.avoid";

}