/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check.util;

import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.util.Objects;

/**
 * @author Peter Shin
 */
public class DockerfileSourceUtil {

	public static boolean endsWithBackSlash(String line) {
		String trimmedLine = StringUtil.trim(line);

		if (Validator.isNotNull(trimmedLine) &&
			trimmedLine.endsWith(StringPool.BACK_SLASH)) {

			return true;
		}

		return false;
	}

	public static String getInstruction(String line, String previousLine) {
		if (Validator.isNull(line) || endsWithBackSlash(previousLine)) {
			return StringPool.BLANK;
		}

		String[] words = StringUtil.split(line, CharPool.SPACE);

		String s = StringUtil.toUpperCase(StringUtil.trim(words[0]));

		if (!s.startsWith(StringPool.POUND)) {
			return s;
		}

		return StringPool.POUND;
	}

	public static boolean isNewInstruction(
		String instruction, String previousInstruction, String previousLine) {

		if (Validator.isNull(previousInstruction) ||
			endsWithBackSlash(previousLine) ||
			Objects.equals(instruction, previousInstruction)) {

			return false;
		}

		return true;
	}

}