/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author Hugo Huijser
 */
public class SourceFormatterConfiguration {

	public void addSourceCheckConfiguration(
		String sourceProcessorName,
		SourceCheckConfiguration sourceCheckConfiguration) {

		List<SourceCheckConfiguration> sourceCheckConfigurations =
			_sourceCheckConfigurationMap.get(sourceProcessorName);

		if (sourceCheckConfigurations == null) {
			sourceCheckConfigurations = new ArrayList<>();
		}

		sourceCheckConfigurations.add(sourceCheckConfiguration);

		_sourceCheckConfigurationMap.put(
			sourceProcessorName, sourceCheckConfigurations);
	}

	public List<SourceCheckConfiguration> getSourceCheckConfigurations(
		String sourceProcessorName) {

		return _sourceCheckConfigurationMap.get(sourceProcessorName);
	}

	public Set<String> getSourceProcessorNames() {
		return _sourceCheckConfigurationMap.keySet();
	}

	private final Map<String, List<SourceCheckConfiguration>>
		_sourceCheckConfigurationMap = new HashMap<>();

}