/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check.configuration;

import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.check.SourceCheck;

import java.util.HashSet;
import java.util.Set;

/**
 * @author Hugo Huijser
 */
public class SourceChecksResult {

	public SourceChecksResult(String content) {
		_content = content;
	}

	public void addSourceFormatterMessage(
		SourceFormatterMessage sourceFormatterMessage) {

		_sourceFormatterMessages.add(sourceFormatterMessage);
	}

	public String getContent() {
		return _content;
	}

	public SourceCheck getMostRecentProcessedSourceCheck() {
		return _mostRecentProcessedSourceCheck;
	}

	public Set<SourceFormatterMessage> getSourceFormatterMessages() {
		return _sourceFormatterMessages;
	}

	public void setContent(String content) {
		_content = content;
	}

	public void setMostRecentProcessedSourceCheck(
		SourceCheck mostRecentProcessedSourceCheck) {

		_mostRecentProcessedSourceCheck = mostRecentProcessedSourceCheck;
	}

	private String _content;
	private SourceCheck _mostRecentProcessedSourceCheck;
	private final Set<SourceFormatterMessage> _sourceFormatterMessages =
		new HashSet<>();

}