/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check.configuration;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;

/**
 * @author Hugo Huijser
 */
public class SourceCheckConfiguration {

	public SourceCheckConfiguration(String category, String name) {
		_category = category;
		_name = name;
	}

	public void addAttribute(String name, String value) {
		JSONArray jsonArray = _attributesJSONObject.getJSONArray(name);

		if (jsonArray == null) {
			jsonArray = new JSONArrayImpl();
		}

		for (String s : StringUtil.split(value, StringPool.COMMA)) {
			jsonArray.put(s);
		}

		_attributesJSONObject.put(name, jsonArray);
	}

	public JSONObject getAttributesJSONObject() {
		return _attributesJSONObject;
	}

	public String getCategory() {
		return _category;
	}

	public String getName() {
		return _name;
	}

	public int getWeight() {
		return _weight;
	}

	public void setWeight(int weight) {
		_weight = weight;
	}

	private final JSONObject _attributesJSONObject = new JSONObjectImpl();
	private final String _category;
	private final String _name;
	private int _weight = -1;

}