/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check.configuration;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.util.SourceUtil;

import java.io.IOException;

import java.util.List;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

/**
 * @author Hugo Huijser
 */
public class ConfigurationLoader {

	public static SourceFormatterConfiguration loadConfiguration(
			String fileName)
		throws DocumentException, IOException {

		SourceFormatterConfiguration sourceFormatterConfiguration =
			new SourceFormatterConfiguration();

		ClassLoader classLoader = ConfigurationLoader.class.getClassLoader();

		String content = StringUtil.read(
			classLoader.getResourceAsStream(fileName));

		Document document = SourceUtil.readXML(content);

		Element rootElement = document.getRootElement();

		for (Element sourceProcessorElement :
				(List<Element>)rootElement.elements("source-processor")) {

			String sourceProcessorName = sourceProcessorElement.attributeValue(
				"name");

			for (Element checkElement :
					(List<Element>)sourceProcessorElement.elements("check")) {

				Element categoryElement = checkElement.element("category");

				SourceCheckConfiguration sourceCheckConfiguration =
					new SourceCheckConfiguration(
						categoryElement.attributeValue("name"),
						checkElement.attributeValue("name"));

				for (Element propertyElement :
						(List<Element>)checkElement.elements("property")) {

					sourceCheckConfiguration.addAttribute(
						propertyElement.attributeValue("name"),
						propertyElement.attributeValue("value"));
				}

				Element weightElement = checkElement.element("weight");

				if (weightElement != null) {
					sourceCheckConfiguration.setWeight(
						GetterUtil.getInteger(weightElement.getText()));
				}

				sourceFormatterConfiguration.addSourceCheckConfiguration(
					sourceProcessorName, sourceCheckConfiguration);
			}
		}

		return sourceFormatterConfiguration;
	}

}