/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check.comparator;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;

import org.dom4j.Element;

/**
 * @author Hugo Huijser
 */
public class ElementComparator extends NaturalOrderStringComparator {

	public ElementComparator() {
		this(_NAME_ATTRIBUTE_DEFAULT);
	}

	public ElementComparator(boolean importPackage) {
		this(_NAME_ATTRIBUTE_DEFAULT, importPackage);
	}

	public ElementComparator(String nameAttribute) {
		this(nameAttribute, false);
	}

	public ElementComparator(String nameAttribute, boolean importPackage) {
		_nameAttribute = nameAttribute;
		_importPackage = importPackage;
	}

	public int compare(Element element1, Element element2) {
		String elementName1 = getElementName(element1);
		String elementName2 = getElementName(element2);

		if ((elementName1 == null) || (elementName2 == null)) {
			return 0;
		}

		if (_importPackage) {
			return elementName1.compareTo(elementName2);
		}

		return super.compare(elementName1, elementName2);
	}

	public String getElementName(Element element) {
		return element.attributeValue(getNameAttribute());
	}

	protected String getNameAttribute() {
		return _nameAttribute;
	}

	protected String getTagValue(Element element) {
		return getTagValue(element, getNameAttribute());
	}

	protected String getTagValue(Element element, String tagName) {
		Element nameElement = element.element(tagName);

		if (nameElement == null) {
			return null;
		}

		return nameElement.getText();
	}

	private static final String _NAME_ATTRIBUTE_DEFAULT = "name";

	private final boolean _importPackage;
	private final String _nameAttribute;

}