/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

/**
 * @author Alan Huang
 */
public class XMLWorkflowDefinitionFileNameCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (content.contains("\n<workflow-definition\n") &&
			!fileName.endsWith("workflow-definition.xml")) {

			addMessage(
				fileName,
				"The file name of workflow definition should end with " +
					"'workflow-definition.xml'");
		}

		return content;
	}

}