/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;

import java.io.IOException;

/**
 * @author Hugo Huijser
 */
public class XMLWhitespaceCheck extends WhitespaceCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws IOException {

		content = StringUtil.replace(content, "\"/>\n", "\" />\n");

		content = content.replaceAll("([\n\t]<\\!--) (<)", "$1$2");

		content = StringUtil.replace(content, "> -->\n", ">-->\n");

		return super.doProcess(fileName, absolutePath, content);
	}

	@Override
	protected String formatDoubleSpace(String line) {
		if (line.contains("<contains") || line.contains("<replacetoken") ||
			line.contains("<replacevalue")) {

			return line;
		}

		return super.formatDoubleSpace(line);
	}

	@Override
	protected boolean isAllowLeadingSpaces(
		String fileName, String absolutePath) {

		if (fileName.startsWith(getBaseDirName() + "build") ||
			fileName.contains("/build")) {

			return true;
		}

		return false;
	}

}