/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;

import java.io.IOException;

import java.util.List;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

/**
 * @author Hugo Huijser
 */
public class XMLSourcechecksFileCheck extends BaseFileCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws DocumentException, IOException {

		if (fileName.endsWith("/sourcechecks.xml")) {
			_checkSourcechecksXML(fileName, content);
		}

		return content;
	}

	private void _checkMissingTag(
		String fileName, Element checkElement, String checkName,
		String tagName) {

		Element tagElement = checkElement.element(tagName);

		if (tagElement == null) {
			addMessage(
				fileName,
				StringBundler.concat(
					"Missing tag '", tagName, "' for check '", checkName, "'"));
		}
	}

	private void _checkSourcechecksXML(String fileName, String content)
		throws DocumentException, IOException {

		Document document = SourceUtil.readXML(content);

		Element rootElement = document.getRootElement();

		checkElementOrder(
			fileName, rootElement, "source-processor", null,
			new ElementComparator());

		for (Element sourceProcessorElement :
				(List<Element>)rootElement.elements("source-processor")) {

			checkElementOrder(
				fileName, sourceProcessorElement, "check",
				sourceProcessorElement.attributeValue("name"),
				new ElementComparator());

			for (Element checkElement :
					(List<Element>)sourceProcessorElement.elements("check")) {

				String checkName = checkElement.attributeValue("name");

				if (!checkName.endsWith("Check")) {
					addMessage(
						fileName,
						StringBundler.concat(
							"Name of class '", checkName,
							"' should end with 'Check'"));
				}

				_checkMissingTag(fileName, checkElement, checkName, "category");
				_checkMissingTag(
					fileName, checkElement, checkName, "description");

				checkElementOrder(
					fileName, checkElement, "property", checkName,
					new ElementComparator());
			}
		}
	}

}