/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Peter Shin
 */
public class XMLProjectElementCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (!absolutePath.endsWith(".pom")) {
			return content;
		}

		String[] lines = StringUtil.splitLines(content);

		if (lines.length == 0) {
			return content;
		}

		String firstLine = lines[0];

		if (!firstLine.matches("\\s*<project.*>\\s*")) {
			return content;
		}

		List<String> list = new ArrayList<>();

		Matcher matcher = _pattern.matcher(firstLine);

		while (matcher.find()) {
			list.add(StringUtil.trim(matcher.group()));
		}

		if (list.isEmpty()) {
			return content;
		}

		list.add(0, "<project");
		list.add(">");

		return StringUtil.replaceFirst(
			content, firstLine, StringUtil.merge(list, "\n\t"));
	}

	private static final Pattern _pattern = Pattern.compile(
		"\\s*\\S*\\s*=\\s*\"[^\"]*\"");

}