/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Seiphon Wang
 */
public class XMLEchoMessageCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws Exception {

		if (!fileName.endsWith(".xml")) {
			return content;
		}

		Matcher matcher = _echoMessagePattern.matcher(content);

		while (matcher.find()) {
			addMessage(
				fileName,
				"Do not use self-closing tag for attribute 'message' in '" +
					"<echo>' tag",
				getLineNumber(content, matcher.start()));
		}

		return content;
	}

	private static final Pattern _echoMessagePattern = Pattern.compile(
		"<echo (.(?!(/>|</)))*?message=.*?/>");

}