/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class SubstringCheck extends BaseFileCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		Matcher matcher = _substringPattern.matcher(content);

		while (matcher.find()) {
			if (ToolsUtil.isInsideQuotes(content, matcher.start(1))) {
				continue;
			}

			String match = content.substring(matcher.start(1));

			List<String> parameterList = JavaSourceUtil.getParameterList(match);

			if (parameterList.size() != 2) {
				continue;
			}

			String secondParameter = StringUtil.trim(parameterList.get(1));
			String variableName = matcher.group(1);

			if (secondParameter.equals(variableName + ".length()")) {
				String replacement = match.replaceFirst(
					",\\s*" + variableName + "\\.length\\(\\)",
					StringPool.BLANK);

				return StringUtil.replaceLast(content, match, replacement);
			}
		}

		return content;
	}

	private static final Pattern _substringPattern = Pattern.compile(
		"\\W([a-z][\\w]*)\\.substring\\(");

}