/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.json.JSONException;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.processor.SourceProcessor;

import java.util.List;
import java.util.Set;

/**
 * @author Hugo Huijser
 */
public interface SourceCheck {

	public Set<SourceFormatterMessage> getSourceFormatterMessages(
		String fileName);

	public int getWeight();

	public boolean isEnabled(String absolutePath);

	public boolean isJavaSource(String content, int pos);

	public boolean isJavaSource(
		String content, int pos, boolean checkInsideTags);

	public boolean isLiferaySourceCheck();

	public boolean isModuleSourceCheck();

	public void setAllFileNames(List<String> allFileNames);

	public void setAttributes(String attributes) throws JSONException;

	public void setBaseDirName(String baseDirName);

	public void setExcludes(String excludes) throws JSONException;

	public void setFileExtensions(List<String> fileExtenstions);

	public void setFilterCheckNames(List<String> filterCheckNames);

	public void setMaxDirLevel(int maxDirLevel);

	public void setMaxLineLength(int maxLineLength);

	public void setPluginsInsideModulesDirectoryNames(
		List<String> pluginsInsideModulesDirectoryNames);

	public void setPortalSource(boolean portalSource);

	public void setProjectPathPrefix(String projectPathPrefix);

	public void setSourceFormatterExcludes(
		SourceFormatterExcludes sourceFormatterExcludes);

	public void setSourceProcessor(SourceProcessor sourceProcessor);

	public void setSubrepository(boolean subrepository);

	public void setWeight(int weight);

}