/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.IOException;

/**
 * @author Alan Huang
 */
public class PythonWhitespaceCheck extends WhitespaceCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws IOException {

		StringBundler sb = new StringBundler();

		try (UnsyncBufferedReader unsyncBufferedReader =
				new UnsyncBufferedReader(new UnsyncStringReader(content))) {

			boolean insideMultiLines = false;

			String line = null;
			String previousLine = null;

			while ((line = unsyncBufferedReader.readLine()) != null) {
				while (line.matches("^\t*    .*")) {
					if (previousLine.endsWith(StringPool.BACK_SLASH) ||
						insideMultiLines) {

						break;
					}

					line = StringUtil.replaceFirst(
						line, StringPool.FOUR_SPACES, StringPool.TAB);
				}

				if (line.contains("'''") || line.contains("\"\"\"")) {
					insideMultiLines = insideMultiLines ^ true;
				}

				sb.append(line);
				sb.append("\n");

				previousLine = line;
			}
		}

		content = sb.toString();

		if (content.endsWith("\n")) {
			content = content.substring(0, content.length() - 1);
		}

		return content;
	}

}