/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringPool;

/**
 * @author Peter Shin
 */
public class PropertiesServiceKeysCheck extends BaseFileCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (!fileName.endsWith("/service.properties")) {
			return content;
		}

		for (String legacyServiceKey : _LEGACY_SERVICE_KEYS) {
			content = content.replaceAll(
				"(\\A|\n)\\s*" + legacyServiceKey + "=.*(\\Z|\n)",
				StringPool.NEW_LINE);
		}

		return content;
	}

	private static final String[] _LEGACY_SERVICE_KEYS = {"build.auto.upgrade"};

}