/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import java.io.IOException;
import java.io.StringReader;

import java.util.Properties;

/**
 * @author Hugo Huijser
 */
public class PropertiesReleaseBuildCheck extends BaseFileCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws IOException {

		if (!absolutePath.endsWith("/release.properties")) {
			return content;
		}

		Properties properties = new Properties();

		properties.load(new StringReader(content));

		String releaseInfoBuildValue = properties.getProperty(
			"release.info.build");

		if (releaseInfoBuildValue == null) {
			return content;
		}

		String releaseInfoContent = getPortalContent(
			"portal-kernel/src/com/liferay/portal/kernel/util/ReleaseInfo.java",
			absolutePath);

		if (!releaseInfoContent.contains(releaseInfoBuildValue)) {
			addMessage(
				fileName,
				"release.info.build '" + releaseInfoBuildValue +
					"' does not exist in ReleaseInfo.java");
		}

		return content;
	}

}