/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.CharPool;
import com.liferay.portal.kernel.util.StringUtil;

/**
 * @author Hugo Huijser
 */
public class MarkdownSourceFormatterDocumentationCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (!absolutePath.contains(
				"/modules/util/source-formatter/src/main/resources" +
					"/documentation/check/")) {

			return content;
		}

		int x = absolutePath.lastIndexOf(CharPool.SLASH);
		int y = absolutePath.lastIndexOf(CharPool.PERIOD);

		String expectedHeaderName = StringUtil.removeChar(
			absolutePath.substring(x + 1, y), CharPool.UNDERLINE);

		if (!StringUtil.startsWith(
				content, "## " + expectedHeaderName + "\n")) {

			addMessage(
				fileName,
				"There should be a header name corresponding with the name " +
					"of the documented check");
		}

		return content;
	}

}