/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.source.formatter.parser.JavaTerm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Minhchau Dang
 */
public class JavaStringStartsWithSubstringCheck extends BaseJavaTermCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, JavaTerm javaTerm,
			String fileContent)
		throws Exception {

		Matcher matcher = _substringContainsPattern.matcher(
			javaTerm.getContent());

		return matcher.replaceAll("$1.startsWith$2");
	}

	@Override
	protected String[] getCheckableJavaTermNames() {
		return new String[] {JAVA_CONSTRUCTOR, JAVA_METHOD};
	}

	private static final Pattern _substringContainsPattern = Pattern.compile(
		"(\\S*)\\.contains(\\(([^))]*)\\).*?=\\s*(\\1)\\.substring\\(" +
			"(\\3)\\.length\\(\\)\\))",
		Pattern.DOTALL);

}