/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JavaSeeAnnotationCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		Matcher matcher = _seeAnnotationPattern.matcher(content);

		while (matcher.find()) {
			addMessage(
				fileName, "Do not use @see with another annotation",
				getLineNumber(content, matcher.start() + 1));
		}

		return content;
	}

	private static final Pattern _seeAnnotationPattern = Pattern.compile(
		"[\n\t] ?\\* @see.*@");

}