/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class JavaIgnoreAnnotationCheck extends BaseJavaTermCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, JavaTerm javaTerm,
		String fileContent) {

		if (!javaTerm.hasAnnotation("Ignore") ||
			!javaTerm.hasAnnotation("Test")) {

			return javaTerm.getContent();
		}

		List<String> classNames = getAttributeValues(
			_CLASS_NAMES_BLACKLIST_KEY, absolutePath);

		JavaClass javaClass = javaTerm.getParentJavaClass();

		if (classNames.contains(javaClass.getName(true))) {
			addMessage(
				fileName, "Do not ignore test in '" + javaClass.getName(),
				javaTerm.getLineNumber());
		}

		return javaTerm.getContent();
	}

	@Override
	protected String[] getCheckableJavaTermNames() {
		return new String[] {JAVA_METHOD};
	}

	private static final String _CLASS_NAMES_BLACKLIST_KEY =
		"classNamesBlacklist";

}