/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.parser.JavaTerm;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JavaEmptyLineAfterSuperCallCheck extends BaseJavaTermCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, JavaTerm javaTerm,
		String fileContent) {

		Pattern pattern = null;

		if (javaTerm.isJavaConstructor()) {
			pattern = _constructorSuperCallPattern;
		}
		else {
			pattern = Pattern.compile(
				"\tsuper\\.\\s*" + javaTerm.getName() + "\\(.*?;\n\t*([^\t])",
				Pattern.DOTALL);
		}

		String javaTermContent = javaTerm.getContent();

		Matcher matcher = pattern.matcher(javaTermContent);

		if (!matcher.find()) {
			return javaTermContent;
		}

		String s = matcher.group(1);

		if (!s.equals(StringPool.CLOSE_CURLY_BRACE) &&
			!s.equals(StringPool.NEW_LINE) &&
			(getLevel(javaTermContent.substring(0, matcher.start())) == 0)) {

			return StringUtil.replaceFirst(
				javaTermContent, ";\n", ";\n\n", matcher.start());
		}

		return javaTermContent;
	}

	@Override
	protected String[] getCheckableJavaTermNames() {
		return new String[] {JAVA_CONSTRUCTOR, JAVA_METHOD};
	}

	private static final Pattern _constructorSuperCallPattern = Pattern.compile(
		"\tsuper\\(.*?;\n\t*([^\t])", Pattern.DOTALL);

}