/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.util.JSPSourceUtil;

import java.io.IOException;

import java.util.ArrayList;
import java.util.Set;

/**
 * @author Hugo Huijser
 */
public class JSPUnusedJSPFCheck extends BaseJSPTermsCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws IOException {

		if (!fileName.endsWith(".jspf")) {
			return content;
		}

		populateContentsMap(fileName, content);

		Set<String> referenceFileNames = JSPSourceUtil.getJSPReferenceFileNames(
			fileName, new ArrayList<>(), getContentsMap(), ".*\\.jspf");

		if (referenceFileNames.isEmpty()) {
			addMessage(fileName, "Unused .jspf file");
		}

		return content;
	}

}