/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JSPFunctionNameCheck extends BaseFileCheck {

	@Override
	public boolean isLiferaySourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		Matcher matcher = _functionPattern.matcher(content);

		while (matcher.find()) {
			String functionName = matcher.group(2);

			if (!functionName.matches(_FUNCTION_NAME_REGEX)) {
				addMessage(
					fileName,
					StringBundler.concat(
						"Function '", functionName, "' much match pattern '",
						_FUNCTION_NAME_REGEX, "'"),
					getLineNumber(content, matcher.start(2)));
			}
		}

		return content;
	}

	private static final String _FUNCTION_NAME_REGEX =
		"^[a-z0-9][_a-zA-Z0-9]*$";

	private static final Pattern _functionPattern = Pattern.compile(
		"[\n\t]function (<.*>)?(\\w+)\\(");

}