/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.util.SourceUtil;

/**
 * @author Seiphon Wang
 */
public class IncorrectFilePathCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		String rootDirName = SourceUtil.getRootDirName(absolutePath);

		if (Validator.isNull(rootDirName)) {
			return content;
		}

		String relativePath = absolutePath.substring(rootDirName.length());

		for (String path : relativePath.split("/")) {
			if (Validator.isNull(path)) {
				continue;
			}

			if (path.endsWith(StringPool.SPACE) ||
				path.startsWith(StringPool.SPACE)) {

				addMessage(
					fileName,
					StringBundler.concat(
						"Do not add leading/trailing spaces in file or folder ",
						"names '", path, "'"));
			}

			for (String illegalCharacter : _ILLEGAL_CHARACTERS) {
				if (path.contains(illegalCharacter)) {
					addMessage(
						fileName,
						StringBundler.concat(
							"Do not use '", illegalCharacter, "' in file or ",
							"folder names '", path, "'"));
				}
			}
		}

		return content;
	}

	private static final String[] _ILLEGAL_CHARACTERS = {
		StringPool.BACK_SLASH, StringPool.COLON, StringPool.FORWARD_SLASH,
		StringPool.GREATER_THAN, StringPool.LESS_THAN, StringPool.PIPE,
		StringPool.QUESTION, StringPool.QUOTE, StringPool.STAR
	};

}