/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ImportsFormatter;
import com.liferay.source.formatter.GradleImportsFormatter;
import com.liferay.source.formatter.parser.GradleFile;

import java.io.IOException;

/**
 * @author Hugo Huijser
 */
public class GradleImportsCheck extends BaseGradleFileCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, GradleFile gradleFile,
			String content)
		throws IOException {

		String importsBlock = gradleFile.getImportsBlock();

		if (Validator.isNull(importsBlock)) {
			return content;
		}

		ImportsFormatter importsFormatter = new GradleImportsFormatter();

		return StringUtil.replaceFirst(
			content, importsBlock,
			importsFormatter.format(importsBlock, null, null));
	}

}