/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class CSSImportsCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		Matcher matcher = _importsPattern.matcher(content);

		while (matcher.find()) {
			String imports = StringUtil.trim(matcher.group());

			String[] lines = StringUtil.splitLines(imports);

			Arrays.sort(lines);

			StringBundler sb = new StringBundler(lines.length * 2);

			for (String line : lines) {
				sb.append(line);
				sb.append("\n");
			}

			sb.setIndex(sb.index() - 1);

			String newImports = sb.toString();

			if (!imports.equals(newImports)) {
				return StringUtil.replaceFirst(
					content, imports, newImports, matcher.start());
			}
		}

		return content;
	}

	private static final Pattern _importsPattern = Pattern.compile(
		"(@import \".*\";(\n|\\Z))+", Pattern.MULTILINE);

}