/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;

/**
 * @author Peter Shin
 */
public class CDNCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		return _fixCDNURL(content);
	}

	private String _fixCDNURL(String content) {
		return StringUtil.replace(
			content,
			new String[] {
				"cdn.lfrs.sl/releases.liferay.com",
				"cdn.lfrs.sl/repository.liferay.com",
				"repository.liferay.com/nexus/content/repositories/",
				"repository.liferay.com/nexus/service/local/repo_groups" +
					"/private/content/"
			},
			new String[] {
				"releases-cdn.liferay.com", "repository-cdn.liferay.com",
				"repository-cdn.liferay.com/nexus/content/repositories/",
				"repository-cdn.liferay.com/nexus/service/local/repo_groups" +
					"/private/content/"
			});
	}

}