/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;

import java.io.IOException;

/**
 * @author Hugo Huijser
 */
public class BNDMultipleAppBNDsCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws IOException {

		if (!absolutePath.endsWith("/app.bnd")) {
			return content;
		}

		_checkMuldipleAppBND(fileName, absolutePath, "dxp");
		_checkMuldipleAppBND(fileName, absolutePath, "private");

		return content;
	}

	private void _checkMuldipleAppBND(
			String fileName, String absolutePath, String dirName)
		throws IOException {

		int x = absolutePath.indexOf("/modules/" + dirName + "/apps/");

		if (x == -1) {
			return;
		}

		String portalAppBNDFileName = StringUtil.replaceFirst(
			absolutePath.substring(x + 1), "/" + dirName + "/", "/");

		if (getPortalContent(portalAppBNDFileName, absolutePath, true) !=
				null) {

			addMessage(
				fileName,
				"Redundant app.bnd. There is one already: '" +
					portalAppBNDFileName + "'.");
		}
	}

}