/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.util.BNDSourceUtil;

import java.io.File;

import java.util.List;

/**
 * @author Alan Huang
 */
public class BNDLiferayRelengBundleCheck extends BaseFileCheck {

	@Override
	public boolean isModuleSourceCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (!absolutePath.endsWith("/app.bnd") ||
			!absolutePath.contains("/modules/dxp/apps/")) {

			return content;
		}

		List<String> allowedLiferayRelengBundleNames = getAttributeValues(
			_ALLOWED_LIFERAY_RELENG_BUNDLE_NAMES, absolutePath);

		for (String allowedLiferayRelengBundleName :
				allowedLiferayRelengBundleNames) {

			if (absolutePath.contains(allowedLiferayRelengBundleName)) {
				return content;
			}
		}

		String liferayRelengBundle = BNDSourceUtil.getDefinitionValue(
			content, "Liferay-Releng-Bundle");

		if (Validator.isNull(liferayRelengBundle) ||
			liferayRelengBundle.equals("false")) {

			return content;
		}

		int pos = absolutePath.lastIndexOf(StringPool.SLASH);

		File file = new File(
			absolutePath.substring(0, pos + 1) + ".lfrbuild-release-src");

		if (!file.exists()) {
			addMessage(
				fileName,
				StringBundler.concat(
					"DXP modules that have a 'app.bnd' file that contains ",
					"'Liferay-Releng-Bundle: true' should have a ",
					"'.lfrbuild-release-src' file"));
		}

		return content;
	}

	private static final String _ALLOWED_LIFERAY_RELENG_BUNDLE_NAMES =
		"allowedLiferayRelengBundleNames";

}