/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.exception.PortalException;

import org.junit.Assert;

/**
 * @author André de Oliveira
 * @author Hugo Huijser
 */
public class SourceMismatchException extends PortalException {

	public SourceMismatchException(
		String fileName, String originalSource, String formattedSource) {

		_fileName = fileName;
		_originalSource = originalSource;
		_formattedSource = formattedSource;
	}

	public String getFileName() {
		return _fileName;
	}

	public String getFormattedSource() {
		return _formattedSource;
	}

	@Override
	public String getMessage() {
		try {
			Assert.assertEquals(_fileName, _formattedSource, _originalSource);
		}
		catch (AssertionError ae) {
			String message = ae.getMessage();

			if (message.length() >= _MAX_MESSAGE_SIZE) {
				message =
					"Truncated message :\n" +
						message.substring(0, _MAX_MESSAGE_SIZE);
			}

			return message;
		}

		return StringPool.BLANK;
	}

	public String getOriginalSource() {
		return _originalSource;
	}

	private static final int _MAX_MESSAGE_SIZE = 10000;

	private final String _fileName;
	private final String _formattedSource;
	private final String _originalSource;

}