/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.poshi.core.prose;

import java.util.regex.Pattern;

import org.dom4j.Element;

/**
 * @author Yi-Chen Tsai
 */
public abstract class BasePoshiProse {

	public String filterCommentLines(String content) {
		return content.replaceAll(commentLinePattern.pattern(), "");
	}

	public abstract Element toElement();

	protected final Pattern commentLinePattern = Pattern.compile("\\s*#.*");
	protected final Pattern tagPattern = Pattern.compile(
		"\\@\\s*(?<tagName>.*?)\\s*\\=\\s*\"(?<tagValue>.*)\"");

}