/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.poshi.core.pql;

import java.util.Properties;

/**
 * @author Michael Hashimoto
 */
public class PQLValue extends PQLEntity {

	public PQLValue(String value) throws Exception {
		super(value);

		_validateValue(value);
	}

	@Override
	public Object getPQLResult(Properties properties) throws Exception {
		return getObjectValue(getPQL());
	}

	protected Object getObjectValue(String value) throws Exception {
		_validateValue(value);

		if (value == null) {
			return null;
		}

		if ((value.startsWith("'") && value.endsWith("'")) ||
			(value.startsWith("\"") && value.endsWith("\""))) {

			value = value.substring(1, value.length() - 1);
		}
		else if (value.contains(" ")) {
			throw new Exception("Invalid value: " + value);
		}

		Object objectValue;

		if (value.equals("null")) {
			return null;
		}
		else if (value.equals("true") || value.equals("false")) {
			objectValue = Boolean.valueOf(value);
		}
		else if (value.matches("\\d+\\.\\d+")) {
			objectValue = Double.valueOf(value);
		}
		else if (value.matches("\\d+")) {
			objectValue = Integer.valueOf(value);
		}
		else {
			objectValue = value;
		}

		PQLModifier pqlModifier = getPQLModifier();

		if (pqlModifier != null) {
			objectValue = pqlModifier.getPQLResult(objectValue);
		}

		return objectValue;
	}

	private void _validateValue(String value) throws Exception {
		if (value == null) {
			return;
		}

		value = removeModifierFromPQL(value);

		if ((value.startsWith("'") && value.endsWith("'")) ||
			(value.startsWith("\"") && value.endsWith("\""))) {

			return;
		}

		if (value.contains(" ")) {
			throw new Exception("Invalid value: " + value);
		}
	}

}