/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.poshi.core.pql;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/**
 * @author Michael Hashimoto
 */
public class PQLEntityFactory {

	public static PQLEntity newPQLEntity(String pql) throws Exception {
		if (pql != null) {
			validateExpressionBalance(pql);
		}

		if (PQLQuery.isQuery(pql)) {
			return new PQLQuery(pql);
		}
		else if (PQLVariable.isVariable(pql)) {
			return new PQLVariable(pql);
		}

		return new PQLValue(pql);
	}

	public static void validateExpressionBalance(String pql) {
		Stack<Integer> stack = new Stack<>();

		for (int i = 0; i < pql.length(); i++) {
			char c = pql.charAt(i);

			if (!stack.isEmpty()) {
				int topIndex = stack.peek();

				Character topCodeBoundary = pql.charAt(topIndex);

				if (c == _codeBoundariesMap.get(topCodeBoundary)) {
					stack.pop();

					continue;
				}

				if (topCodeBoundary == '\"') {
					continue;
				}
			}

			if (_codeBoundariesMap.containsKey(c)) {
				stack.push(i);

				continue;
			}

			if (_codeBoundariesMap.containsValue(c)) {
				throw new RuntimeException(
					"Invalid PQL: Unexpected closing boundary '" +
						pql.charAt(i) + "'\n" + pql);
			}
		}

		if (!stack.isEmpty()) {
			throw new RuntimeException(
				"Invalid PQL: Unmatched opening boundary '" +
					pql.charAt(stack.peek()) + "'\n" + pql);
		}
	}

	private static final Map<Character, Character> _codeBoundariesMap =
		new HashMap<Character, Character>() {
			{
				put('(', ')');
				put('\"', '\"');
			}
		};

}