/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.PropsValues;

import org.dom4j.Comment;
import org.dom4j.tree.DefaultComment;

/**
 * @author Michael Hashimoto
 */
public abstract class PoshiComment
	extends DefaultComment implements PoshiNode<Comment, PoshiComment> {

	public PoshiComment() {
		super("");
	}

	@Override
	public String getPoshiScript() {
		return _poshiScript;
	}

	public abstract boolean isPoshiScriptComment(String poshiScript);

	@Override
	public void setPoshiScript(String poshiScript) {
		_poshiScript = poshiScript;
	}

	protected PoshiComment(Comment comment) {
		super(comment.getText());
	}

	protected PoshiComment(String poshiScript)
		throws PoshiScriptParserException {

		this();

		setPoshiScript(poshiScript);

		parsePoshiScript(poshiScript.trim());

		if (PropsValues.TEST_POSHI_SCRIPT_VALIDATION) {
			validatePoshiScript();
		}
	}

	private String _poshiScript;

}