/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.source.formatter.ImportPackage;
import com.liferay.source.formatter.ImportsFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPImportsFormatter
extends ImportsFormatter {
    private static final Pattern _jspImportPattern = Pattern.compile("import=\"([^\\s\"]+)\"");
    private static final Pattern _jspTaglibPattern = Pattern.compile("uri=\"http://([^\\s\"]+)\"");

    @Override
    protected ImportPackage createImportPackage(String line) {
        Matcher matcher = _jspImportPattern.matcher(line);
        if (matcher.find()) {
            return new ImportPackage(matcher.group(1), false, line);
        }
        matcher = _jspTaglibPattern.matcher(line);
        if (matcher.find()) {
            return new ImportPackage(matcher.group(1), false, line);
        }
        return null;
    }
}

