/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.JavaSourceProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSourceTabCalculator {
    private Map<Integer, Integer> _extraTabMap;
    private Set<Integer> _ignoreTabCheck;
    private Pattern _methodDeclarationPattern = Pattern.compile("^\\s*(private|protected|public) .*?(\\{|;)\n", 32);
    private boolean _printIncorrectTabMessage;
    private Pattern _throwsExceptionPattern = Pattern.compile("\t((default .*)|(throws (E|(.*(Error|Exception|Fault|Throwable)))))(;| \\{)$", 32);
    private Pattern _trailingCommentPattern = Pattern.compile("(\n|\t).*\\S(( |\t)+//.*?)\n");

    public void calculateTabs(String fileName, String content, JavaSourceProcessor javaSourceProcessor) throws Exception {
        content = this.stripTrailingComments(content);
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineCount = 0;
            boolean forClause = false;
            boolean ifClause = false;
            boolean multiLineComment = false;
            int tabLevel = 0;
            this._extraTabMap = new HashMap<Integer, Integer>();
            this._ignoreTabCheck = new HashSet<Integer>();
            this._printIncorrectTabMessage = true;
            String remainingContent = content;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                String trimmedLine = StringUtil.trimLeading(line);
                int leadingTabCount = BaseSourceProcessor.getLeadingTabCount(line);
                if (trimmedLine.startsWith("/*") && !trimmedLine.startsWith("/**")) {
                    multiLineComment = true;
                }
                if (!multiLineComment) {
                    if (trimmedLine.startsWith("for (") || trimmedLine.startsWith("try (")) {
                        forClause = true;
                    }
                    if (line.endsWith(") {")) {
                        forClause = false;
                    }
                    if (Validator.isNotNull(line) && !ifClause) {
                        this.checkTabLevel(trimmedLine, leadingTabCount, tabLevel, fileName, lineCount, javaSourceProcessor);
                    }
                    if (trimmedLine.startsWith("catch (") || trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (")) {
                        ifClause = true;
                    }
                    if (!(trimmedLine.startsWith("*") || trimmedLine.startsWith("/*") || trimmedLine.startsWith("//"))) {
                        tabLevel = this.calculateTabLevel(tabLevel, line);
                        this.calculateExtraTabs(trimmedLine, lineCount, remainingContent, forClause, ifClause);
                    }
                } else if (line.endsWith("*/")) {
                    multiLineComment = false;
                }
                remainingContent = StringUtil.replaceFirst(remainingContent, line + "\n", "");
                if (!line.endsWith(";") && !line.endsWith(") {")) continue;
                ifClause = false;
            }
        }
    }

    protected void addExtraTabs(int lineCount, int extra) {
        for (int i = lineCount + 1; i <= lineCount + extra; ++i) {
            Integer count = this._extraTabMap.get(i);
            if (count == null) {
                count = 0;
            }
            this._extraTabMap.put(i, count + 1);
        }
    }

    protected void addIgnoreTabChecks(int lineCount, int extra) {
        for (int i = lineCount + 1; i <= lineCount + extra; ++i) {
            this._ignoreTabCheck.add(i);
        }
    }

    protected int adjustTabLevel(int level, String text, String s, int diff) {
        String[] lines;
        for (String line : lines = StringUtil.splitLines(text)) {
            if ((line = StringUtil.trim(line)).startsWith("//")) continue;
            int x = -1;
            while ((x = line.indexOf(s, x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(line, x)) continue;
                level += diff;
            }
        }
        return level;
    }

    protected void calculateExtraTabs(String line, int lineCount, String remainingContent, boolean forClause, boolean ifClause) {
        int extra;
        String s;
        int lineTabLevel;
        block23: {
            String match;
            Matcher matcher2;
            if (Validator.isNull(line)) {
                return;
            }
            Matcher matcher1 = this._methodDeclarationPattern.matcher(remainingContent);
            if (matcher1.find() && (matcher2 = this._throwsExceptionPattern.matcher(match = matcher1.group())).find()) {
                this.addExtraTabs(lineCount, StringUtil.count(match, "\n") - 1);
            }
            if (this.skipCalculateExtraTabs(line, lineTabLevel = this.calculateTabLevel(0, line), forClause, ifClause)) {
                return;
            }
            String[] texts = new String[]{"{\n", ";\n", ",\n", "\n)", "\t)", "\t}", ")\n"};
            if (line.endsWith(":")) {
                if (line.startsWith("case ") || line.startsWith("default")) {
                    texts = new String[]{":\n", "\t}"};
                } else if (!line.endsWith(" :")) {
                    return;
                }
            }
            if (line.endsWith(",") && (line.startsWith("extends ") || line.startsWith("implements ") || line.startsWith("throws "))) {
                texts = new String[]{"{\n", ";\n"};
            }
            if (forClause && (line.endsWith(";") || line.endsWith("=") || line.endsWith("("))) {
                texts = new String[]{"{\n"};
            }
            int x = -1;
            block0: while (true) {
                Tuple tuple;
                if ((x = ((Integer)(tuple = this.getFirstOccurenceTuple(remainingContent, texts, x + 1)).getObject(1)).intValue()) == -1) {
                    return;
                }
                String matchingText = (String)tuple.getObject(0);
                s = StringUtil.trimLeading(remainingContent.substring(0, x));
                int level = this.calculateTabLevel(0, s);
                if ((line.startsWith("case ") || line.startsWith("default")) && line.endsWith(":") && (!s.contains("\n") || level != 0) || level > 0) continue;
                if (matchingText.equals("{\n")) {
                    Tuple tuple2;
                    int y = -1;
                    while ((y = ((Integer)(tuple2 = this.getFirstOccurenceTuple(s, new String[]{"\tnew ", " new "}, y + 1)).getObject(1)).intValue()) != -1) {
                        if (this.calculateTabLevel(0, s.substring(y)) != 0) continue;
                        continue block0;
                    }
                }
                if (matchingText.equals(",\n")) {
                    int greaterThanCount = StringUtil.count(s, ">");
                    int lessThanCount = StringUtil.count(s, "<");
                    if (lessThanCount > greaterThanCount) continue;
                }
                extra = StringUtil.count(s, "\n");
                if (matchingText.equals("\t)") || matchingText.equals("\t}") || matchingText.equals(":\n")) {
                    --extra;
                }
                if (StringUtil.trim(s).endsWith("Exception") && s.contains("\tthrows ")) {
                    --extra;
                }
                if (!line.startsWith("extends ") || line.endsWith(",")) break block23;
                int pos = remainingContent.indexOf("\n");
                String remainingContentMinusFirstLine = StringUtil.trim(remainingContent.substring(pos));
                if (!remainingContentMinusFirstLine.startsWith("implements ")) break;
            }
            extra = 1;
        }
        if (!forClause && !ifClause && (lineTabLevel > 1 || line.startsWith("(") && !line.contains(")") && lineTabLevel == 1)) {
            this.addIgnoreTabChecks(lineCount, extra);
            return;
        }
        if (line.startsWith("-(") || line.endsWith("&") || line.endsWith("|") || line.endsWith("+") && extra > 2) {
            this.addIgnoreTabChecks(lineCount, extra);
            return;
        }
        if (line.endsWith("(") && forClause) {
            if (s.contains(";\n")) {
                this.addIgnoreTabChecks(lineCount, extra);
            }
            return;
        }
        if (lineTabLevel == 0 && !line.startsWith(")") && line.endsWith("(")) {
            this.addIgnoreTabChecks(lineCount, extra);
            return;
        }
        this.addExtraTabs(lineCount, extra);
        String lineMinusLastChar = StringUtil.trim(line.substring(0, line.length() - 1));
        if (lineMinusLastChar.endsWith(")") && lineTabLevel < 0) {
            this.addExtraTabs(lineCount, extra);
        }
        if (line.endsWith(",") && (line.startsWith("extends ") || line.startsWith("implements "))) {
            this.addExtraTabs(lineCount, extra);
            this.addExtraTabs(lineCount, extra);
        }
    }

    protected int calculateTabLevel(int level, String text) {
        level = this.adjustTabLevel(level, text, "{", 1);
        level = this.adjustTabLevel(level, text, "}", -1);
        level = this.adjustTabLevel(level, text, "(", 1);
        level = this.adjustTabLevel(level, text, ")", -1);
        return level;
    }

    protected void checkTabLevel(String trimmedLine, int leadingTabCount, int tabLevel, String fileName, int lineCount, JavaSourceProcessor javaSourceProcessor) {
        if (this._ignoreTabCheck.contains(lineCount)) {
            this._printIncorrectTabMessage = true;
            return;
        }
        if (this.hasCorrectTabCount(trimmedLine, leadingTabCount, tabLevel, lineCount)) {
            this._printIncorrectTabMessage = true;
        } else {
            if (this._printIncorrectTabMessage) {
                javaSourceProcessor.processErrorMessage(fileName, "Incorrect tab or line break: " + fileName + " " + lineCount);
            }
            this._printIncorrectTabMessage = false;
        }
    }

    protected Tuple getFirstOccurenceTuple(String s, String[] texts, int startIndex) {
        String matchingText = null;
        int firstIndexOf = -1;
        for (String text : texts) {
            int x = s.indexOf(text, startIndex);
            if (x == -1 || firstIndexOf != -1 && x >= firstIndexOf) continue;
            firstIndexOf = x;
            matchingText = text;
        }
        return new Tuple(matchingText, firstIndexOf);
    }

    protected boolean hasCorrectTabCount(String trimmedLine, int leadingTabCount, int tabLevel, int lineCount) {
        Integer extraTabs = this._extraTabMap.get(lineCount);
        if (extraTabs == null) {
            extraTabs = 0;
        }
        if (trimmedLine.startsWith("}") || trimmedLine.startsWith(")")) {
            return leadingTabCount + 1 == tabLevel + extraTabs;
        }
        return leadingTabCount == tabLevel + extraTabs;
    }

    protected boolean skipCalculateExtraTabs(String line, int lineTabLevel, boolean forClause, boolean ifClause) {
        if (line.startsWith("@") || line.equals("}") || line.equals(")")) {
            return true;
        }
        if (!forClause && !ifClause && (lineTabLevel > 1 || line.startsWith("(") && !line.contains(")") && lineTabLevel == 1)) {
            return false;
        }
        if (lineTabLevel == 0 && !line.startsWith(")") && line.endsWith("(")) {
            return false;
        }
        if ((line.endsWith("(") || line.endsWith("{")) && !forClause) {
            return true;
        }
        if (line.endsWith(";") && !forClause) {
            return true;
        }
        if (!(!line.endsWith(",") || line.startsWith("extends ") || line.startsWith("implements ") || line.startsWith("throws ") || line.startsWith("<"))) {
            return true;
        }
        if (line.endsWith(")") && !line.startsWith("(") && !line.startsWith("return (")) {
            return true;
        }
        return line.startsWith("(") && lineTabLevel > 0;
    }

    protected String stripTrailingComments(String content) {
        Matcher matcher = this._trailingCommentPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            if (ToolsUtil.isInsideQuotes(match, matcher.start(2) - matcher.start())) continue;
            String replacement = StringUtil.replace(match, matcher.group(2), "");
            content = StringUtil.replace(content, match, replacement);
        }
        return content;
    }
}

