/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.ftl"};
    private Pattern _multiParameterTag = Pattern.compile("\n(\t*)<@.+=.+=.+/>");
    private Pattern _singleParameterTag = Pattern.compile("(<@[\\w\\.]+ \\w+)( )?=([^=]+?)/>");

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String match;
        Matcher matcher = this._singleParameterTag.matcher(content);
        while (matcher.find()) {
            String group3;
            String replacement = match = matcher.group();
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            if (group2 != null) {
                replacement = StringUtil.replaceFirst(replacement, group1 + " ", group1);
            }
            if ((group3 = matcher.group(3)).startsWith(" ")) {
                replacement = StringUtil.replaceLast(replacement, group3, group3.substring(1));
            }
            content = StringUtil.replace(content, match, replacement);
        }
        matcher = this._multiParameterTag.matcher(content);
        while (matcher.find()) {
            String strippedMatch;
            match = matcher.group();
            if (match.contains("><") || StringUtil.count(strippedMatch = FTLSourceProcessor.stripQuotes(match, '\"'), "=") <= 1) continue;
            String replacement = match;
            String tabs = matcher.group(1);
            int x = -1;
            while ((x = replacement.indexOf("=", x + tabs.length() + 2)) != -1) {
                if (ToolsUtil.isInsideQuotes(replacement, x)) continue;
                int y = replacement.lastIndexOf(" ", x);
                if (y == -1) break;
                replacement = replacement.substring(0, y) + "\n" + tabs + "\t" + replacement.substring(y + 1);
            }
            if (match.equals(replacement)) continue;
            replacement = StringUtil.replaceLast(replacement, "/>", "\n" + tabs + "/>");
            content = StringUtil.replace(content, match, replacement);
        }
        return this.trimContent(content, false);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/journal/dependencies/template.ftl", "**/service/builder/dependencies/props.ftl"};
        return this.getFileNames(excludes, this.getIncludes());
    }
}

