/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.source.formatter.BaseSourceProcessor;
import java.io.File;
import java.util.List;

public class BNDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.bnd"};

    @Override
    public String[] getIncludes() {
        return _INCLUDES;
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("-web/bnd.bnd") && content.contains("Require-SchemaVersion: 1.0.0")) {
            this.processErrorMessage(fileName, "Do not include the header Require-SchemaVersion in web modules: " + fileName);
        }
        return this.trimContent(content, false);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }
}

