/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonStylingCheck
extends BaseFileCheck {
    private static final String _MAX_LINE_LENGTH = "maxLineLength";
    private static final Pattern _classDefinitionHeaderPattern = Pattern.compile("(?<=\n)(\t*)class (\\w+)(\\((.*?)\\))?:\n+", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._formatClassDefinitionHeader(absolutePath, content);
    }

    private String _formatClassDefinitionHeader(String absolutePath, String content) {
        int maxLineLength = 0;
        try {
            maxLineLength = Integer.parseInt(this.getAttributeValue(_MAX_LINE_LENGTH, absolutePath));
        }
        catch (NumberFormatException numberFormatException) {
            return content;
        }
        Matcher matcher = _classDefinitionHeaderPattern.matcher(content);
        while (matcher.find()) {
            List<String> parentClassList = ListUtil.fromString(matcher.group(4), ",");
            for (int i = 0; i < parentClassList.size(); ++i) {
                parentClassList.set(i, StringUtil.trim(parentClassList.get(i)));
            }
            StringBundler sb = new StringBundler(7);
            String indent = matcher.group(1);
            sb.append(indent);
            sb.append("class ");
            sb.append(matcher.group(2));
            if (ListUtil.isNotEmpty(parentClassList)) {
                sb.append("(");
                sb.append(ListUtil.toString(parentClassList, "", ", "));
                sb.append(")");
            }
            sb.append(":");
            content = StringUtil.replace(content, matcher.group(), this._splitLine(sb.toString(), indent + "\t", maxLineLength) + "\n\n");
        }
        return content;
    }

    private String _splitLine(String line, String indent, int maxLineLength) {
        if (line.length() <= maxLineLength) {
            return line;
        }
        int pos = line.indexOf(", ", indent.length());
        if (pos == -1) {
            return line;
        }
        if (pos > maxLineLength) {
            return StringBundler.concat(line.substring(0, pos + 1), "\n", this._splitLine(indent + StringUtil.trimLeading(line.substring(pos + 2)), indent, maxLineLength));
        }
        pos = line.lastIndexOf(", ", maxLineLength);
        return StringBundler.concat(line.substring(0, pos + 1), "\n", this._splitLine(indent + StringUtil.trimLeading(line.substring(pos + 2)), indent, maxLineLength));
    }
}

