/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

public class PropertiesReleaseBuildCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!absolutePath.endsWith("/release.properties")) {
            return content;
        }
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        String releaseInfoBuildValue = properties.getProperty("release.info.build");
        if (releaseInfoBuildValue == null) {
            return content;
        }
        String releaseInfoContent = this.getPortalContent("portal-kernel/src/com/liferay/portal/kernel/util/ReleaseInfo.java", absolutePath);
        if (!releaseInfoContent.contains(releaseInfoBuildValue)) {
            this.addMessage(fileName, "release.info.build '" + releaseInfoBuildValue + "' does not exist in ReleaseInfo.java");
        }
        return content;
    }
}

